/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.network.play;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.mrcrayfish.configured.Config;
import com.mrcrayfish.configured.Configured;
import com.mrcrayfish.configured.api.ConfigType;
import com.mrcrayfish.configured.impl.simple.SimpleConfigManager;
import com.mrcrayfish.configured.network.PacketHandler;
import com.mrcrayfish.configured.network.message.MessageRequestSimpleConfig;
import com.mrcrayfish.configured.network.message.MessageResponseSimpleConfig;
import com.mrcrayfish.configured.network.message.MessageSyncForgeConfig;
import com.mrcrayfish.configured.network.message.MessageSyncSimpleConfig;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ServerPlayHandler {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");

    public static void handleSyncServerConfigMessage(ServerPlayer player, MessageSyncForgeConfig message) {
        if (!ServerPlayHandler.canEditServerConfigs(player)) {
            return;
        }
        Configured.LOGGER.debug("Received server config sync from player: {}", (Object)player.m_7755_().getString());
        ModConfig config = ConfigHelper.getForgeConfig(message.fileName());
        if (config == null) {
            Configured.LOGGER.warn("{} tried to update a config that doesn't exist!", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)new TranslatableComponent("configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (config.getType() != ModConfig.Type.SERVER) {
            Configured.LOGGER.warn("{} tried to update a forge config that isn't a server type", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)new TranslatableComponent("configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        ForgeConfigSpec spec = ConfigHelper.findForgeConfigSpec((UnmodifiableConfig)config.getSpec());
        if (spec == null) {
            Configured.LOGGER.warn("Unable to process server config update due to unknown spec for config: {}", (Object)message.fileName());
            player.f_8906_.m_9942_((Component)new TranslatableComponent("configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        try {
            CommentedConfig data = (CommentedConfig)TomlFormat.instance().createParser().parse((InputStream)new ByteArrayInputStream(message.data()));
            int result = spec.correct(data, (action, path, incorrectValue, correctedValue) -> Configured.LOGGER.warn("Incorrect key {} was corrected from {} to its default, {}. {}", (Object)DOT_JOINER.join((Iterable)path), incorrectValue, correctedValue, (Object)(incorrectValue == correctedValue ? "This seems to be an error." : "")), (action, path, incorrectValue, correctedValue) -> Configured.LOGGER.debug("The comment on key {} does not match the spec. This may create a backup.", (Object)DOT_JOINER.join((Iterable)path)));
            if (result != 0) {
                Configured.LOGGER.info("Config data sent from {} needed to be corrected", (Object)player.m_7755_().getString());
            }
            config.getConfigData().putAll((UnmodifiableConfig)data);
        }
        catch (ParsingException e) {
            Configured.LOGGER.warn("{} sent malformed config data to the server", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)new TranslatableComponent("configured.multiplayer.disconnect.invalid_config_packet"));
            ServerPlayHandler.sendMessageToOperators((Component)new TranslatableComponent("configured.chat.malformed_config_data", new Object[]{player.m_7755_(), new TextComponent(config.getFileName()).m_130940_(ChatFormatting.GRAY)}).m_130940_(ChatFormatting.RED));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Configured.LOGGER.debug("Successfully processed config update for '" + message.fileName() + "'");
        PacketHandler.getPlayChannel().send(PacketDistributor.ALL.noArg(), (Object)new MessageSyncForgeConfig(message.fileName(), message.data()));
        ServerPlayHandler.sendMessageToOperators((Component)new TranslatableComponent("configured.chat.config_updated", new Object[]{player.m_7755_(), config.getFileName()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
    }

    public static void handleSyncSimpleConfigMessage(NetworkEvent.Context context, ServerPlayer player, MessageSyncSimpleConfig message) {
        if (!ServerPlayHandler.canEditServerConfigs(player)) {
            return;
        }
        Configured.LOGGER.debug("Received server config sync from player: {}", (Object)player.m_7755_().getString());
        SimpleConfigManager.SimpleConfigImpl config = SimpleConfigManager.getInstance().getConfig(message.id());
        if (config == null) {
            Configured.LOGGER.error("Client sent data for a config that doesn't exist: {}", (Object)message.id());
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (config.isReadOnly()) {
            Configured.LOGGER.error("Client sent data for a read-only config '{}'", (Object)message.id());
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.getType().isServer() || config.getType() == ConfigType.DEDICATED_SERVER) {
            Configured.LOGGER.error("Client sent data for a config is not supposed to be updated '{}'", (Object)message.id());
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (!config.isLoaded()) {
            Configured.LOGGER.error("Client tried to perform sync update on an unloaded config. Something went wrong...");
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.bad_config_packet"));
            return;
        }
        if (SimpleConfigManager.getInstance().processSyncData(message, true)) {
            if (config.getType().isSync()) {
                PacketHandler.getPlayChannel().send(PacketDistributor.ALL.noArg(), (Object)new MessageSyncSimpleConfig(message.id(), message.data()));
            }
            ServerPlayHandler.sendMessageToOperators((Component)new TranslatableComponent("configured.chat.config_updated", new Object[]{player.m_7755_(), config.getFileName()}).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        } else {
            context.getNetworkManager().m_129507_((Component)new TranslatableComponent("configured.multiplayer.disconnect.bad_config_packet"));
        }
    }

    private static void sendMessageToOperators(Component message) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Preconditions.checkNotNull((Object)server, (Object)"The server was null when broadcasting config changes. This should not be possible...");
        for (ServerPlayer serverPlayer : server.m_6846_().m_11314_()) {
            if (!server.m_6846_().m_11303_(serverPlayer.m_36316_())) continue;
            serverPlayer.m_6352_(message, Util.f_137441_);
        }
    }

    public static void handleRequestSimpleConfigMessage(ServerPlayer player, MessageRequestSimpleConfig message, NetworkEvent.Context context) {
        if (!ServerPlayHandler.canEditServerConfigs(player)) {
            return;
        }
        Configured.LOGGER.debug("Received config request from player: {}", (Object)player.m_7755_().getString());
        SimpleConfigManager.SimpleConfigImpl config = SimpleConfigManager.getInstance().getConfig(message.id());
        if (config == null) {
            Configured.LOGGER.warn("{} tried to request server config which does not exist!", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)new TranslatableComponent("configured.multiplayer.disconnect.no_permission"));
            return;
        }
        if (!config.getType().isServer() || config.getType() == ConfigType.DEDICATED_SERVER) {
            Configured.LOGGER.warn("{} tried to request an invalid config from the server", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)new TranslatableComponent("configured.multiplayer.disconnect.no_permission"));
            return;
        }
        try {
            ResourceLocation key = config.getName();
            byte[] data = config.getData();
            PacketHandler.getPlayChannel().reply((Object)new MessageResponseSimpleConfig(key, data), context);
            Configured.LOGGER.debug("Sending request reply back to player");
        }
        catch (Exception e) {
            Configured.LOGGER.warn("An exception occurred to read server config: {}", (Object)config.getFilePath());
            PacketHandler.getPlayChannel().reply((Object)new MessageResponseSimpleConfig(config.getName(), new byte[0]), context);
        }
    }

    private static boolean canEditServerConfigs(ServerPlayer player) {
        MinecraftServer server = player.m_20194_();
        if (server == null || !server.m_6982_() || !((Boolean)Config.DEVELOPER.enabled.get()).booleanValue()) {
            Configured.LOGGER.warn("{} tried to request or update a server config, however developer mode is not enabled", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)new TranslatableComponent("configured.multiplayer.disconnect.unauthorized_request"));
            ServerPlayHandler.sendMessageToOperators((Component)new TranslatableComponent("configured.chat.authorized_player").m_130940_(ChatFormatting.RED));
            return false;
        }
        if (!((List)Config.DEVELOPER.developers.get()).contains(player.m_20149_()) || !server.m_6846_().m_11303_(player.m_36316_())) {
            Configured.LOGGER.warn("{} tried to request or update a server config, however they are not a developer", (Object)player.m_7755_().getString());
            player.f_8906_.m_9942_((Component)new TranslatableComponent("configured.multiplayer.disconnect.unauthorized_request"));
            ServerPlayHandler.sendMessageToOperators((Component)new TranslatableComponent("configured.chat.authorized_player").m_130940_(ChatFormatting.RED));
            return false;
        }
        return true;
    }
}

